if (menu_active) {
    draw_set_font(global.font_main);

    // Iekšējo attālumu pielāgojumi
    var icon_padding = 8; // Horizontālais attālums no kreisās malas
    var icon_vertical_padding = 8; // Vertikālais attālums no augšējās malas
    var icon_spacing = 4; // Attālums starp ikonām un tekstu
    var option_spacing = 20; // Attālums starp opcijām, lai izveidotu attālumu zem teksta
    var text_offset_y = -4; // Offset, lai samazinātu attālumu virs teksta

    // Dinamiski aprēķināt izvēlnes izmērus
    var _new_w = 0;
    for (var i = 0; i < op_length; i++) {
        var selectedIndex = ds_list_find_value(global.selectedPowerUps, i);
        if (selectedIndex >= 0) {
            var _op_w = icon_padding + sprite_get_width(powerUps[selectedIndex].icon) + icon_spacing + string_width(powerUps[selectedIndex].name);
            _new_w = max(_new_w, _op_w);
        } else if (selectedIndex == -1) {
            var _op_w = string_width("No power-ups left!");
            _new_w = max(_new_w, _op_w);
        } else if (selectedIndex == -2) {
            var _op_w = string_width("Back");
            _new_w = max(_new_w, _op_w);
        }
    }

    width = _new_w + op_border * 2;
    height = icon_vertical_padding + op_border * 2 + string_height(powerUps[0].name) + (op_length - 1) * option_spacing;

    // Centra izvēlnes novietošana
    x = camera_get_view_x(view_camera[0]) + camera_get_view_width(view_camera[0]) / 2 - width / 2;
    y = camera_get_view_y(view_camera[0]) + camera_get_view_height(view_camera[0]) / 2 - height / 2;

    // Zīmē izvēlnes fonu
    draw_sprite_ext(sprite_index, image_index, x, y, width / sprite_width, height / sprite_height, 0, c_white, 1);

    // Zīmē opcijas
    draw_set_valign(fa_top);
    draw_set_halign(fa_left);
    for (var i = 0; i < op_length; i++) {
        var selectedIndex = ds_list_find_value(global.selectedPowerUps, i);

        if (selectedIndex >= 0) {
            // Nosaka krāsu izvēlētajai opcijai
            var _c = (pos == i) ? c_yellow : c_white;

            // Ikonas pozīcija ar iekšējo attālumu
            var icon_x = x + op_border + icon_padding;
            var icon_y = y + op_border + icon_vertical_padding + option_spacing * i;

            // Teksta pozīcija ar samazinātu attālumu virs teksta
            var text_x = icon_x + sprite_get_width(powerUps[selectedIndex].icon) + icon_spacing;
            var text_y = icon_y + text_offset_y; // Teksta pielāgošana, lai samazinātu attālumu virs tā

            // Zīmē ikonu
            draw_sprite(powerUps[selectedIndex].icon, 0, icon_x, icon_y);

            // Zīmē tekstu
            draw_text_color(text_x, text_y, powerUps[selectedIndex].name, _c, _c, _c, _c, 1);
        } else if (selectedIndex == -1) {
            // Zīmē ziņojumu "Nav power-upu atlikušos!"
            var _c = (pos == i) ? c_yellow : c_white;
            draw_set_halign(fa_center);
            draw_set_valign(fa_middle);
            draw_text_color(x + width / 2, y + icon_vertical_padding + option_spacing * i, "No power-ups left!", _c, _c, _c, _c, 1);
        } else if (selectedIndex == -2) {
            // Zīmē "Atpakaļ" opciju
            var _c = (pos == i) ? c_yellow : c_white;
            draw_set_halign(fa_left);
            draw_set_valign(fa_top);
            draw_text_color(x + op_border, y + icon_vertical_padding + option_spacing * i, "Back", _c, _c, _c, _c, 1);
        }
    }
}
